#ifndef __CAnimationFrame__
#define __CAnimationFrame__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CAnimationFrame CAnimationFrame.hpp
			 * @brief Displays an animation, you choose which frame its showing directly with an index
			 *
			 * @date 31/05/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CAnimationFrame.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CAnimationFrame : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 */
				CAnimationFrame(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CAnimationFrame();

//	===========================================================================

				/**
				 * Set the image
				 * @param theImage The image to display
				 * @param heightOfEachFrame The height of each frame of the animation
				 */
				virtual void setAnimationImage(IImage *theImage, const long heightOfEachFrame);

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Set the frame number
				 * @param frameNumber The frame to display
				 */
				virtual void setFrameNumber(const long frameNumber);

				/**
				 * Handle left button being clicked
				 * @param event The mouse event
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

//	===========================================================================

			protected:

//	===========================================================================

				long m_frameHeight;			/**< Total height of each frame */
				long m_frameNumber;			/**< Which frame is currently being displayed */
				CRect m_offsetArea;			/**< What is the area to be drawn? */
			};
		}
	}
}
#endif	// End of CAnimationFrame.hpp